<?php
require_once '../conexiones/conexion.php';

// Habilitar errores para depuración
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Procesar la acción de eliminar un usuario
if (isset($_GET['delete']) && is_numeric($_GET['delete'])) {
    $usuario_id = intval($_GET['delete']); // Asegurarse de que sea un número entero

    // Verificar si el usuario existe
    $stmt = $pdo->prepare("SELECT id FROM usuarios WHERE id = ?");
    $stmt->execute([$usuario_id]);

    if ($stmt->rowCount() > 0) {
        // Eliminar el usuario de la base de datos
        $stmt = $pdo->prepare("DELETE FROM usuarios WHERE id = ?");
        $stmt->execute([$usuario_id]);

        // Redirigir después de la eliminación
        header('Location: ../usuarios.php');
        exit;
    } else {
        // Mostrar mensaje de error si el usuario no existe
        echo "Error: El usuario no existe.";
        header('Refresh: 3; URL=../usuarios.php'); // Redirigir después de 3 segundos
        exit;
    }
} else {
    // Si no se proporciona un ID válido, redirigir a la lista de usuarios
    header('Location: ../usuarios.php');
    exit;
}
?>
